%% Cell segmentation using superSegger
% segment cells using SuperSegger (Stylianidou et al. 2016)
% this gives folder structure that is used in this script

% estimate alignment from spots
estimateAlignment

% collect data from population exp
generateSpotsPop(2, out)     % 2 - fluo3 has areas

% load spotsPop.mat 

%% Brightest pixel distance to closest ori/ter
% assumes ori - fluo1, ter - fluo2, MukB - fluo3

pixel = 0.11;       % pixel size microscopy
maxImage = 596;     % size of the image in px
distEdge = 10;      % minimum distance of cell to edge

ori_dist_bright = [];   % distance to brightest px
ter_dist_bright = [];   % distance to brightest px
ter_coord = NaN(30000,2);
mukb_coord = NaN(30000,2);
for ii = 1:length(spots)
    % cells that have 1 ori spot
    if length(spots(ii).fluo1.l) == 1 && ~isempty(spots(ii).fluo3A.coord)
        % brightest px
        Ints = double(spots(ii).fluo3A.Int);
        [~,I] = max(Ints);
        X2 = spots(ii).fluo3A.coord(I,:);

        ter_coord(ii,:) = spots(ii).fluo1.coord-[spots(ii).X spots(ii).Y];
        mukb_coord(ii,:) = X2-[spots(ii).X spots(ii).Y];

        % ter
        xcoord = spots(ii).fluo1.coord(1:2:end);
        ycoord = spots(ii).fluo1.coord(2:2:end);
        X1 = [xcoord' ycoord'];
        X = [X2; X1];
        d = pdist(X,'euclidean');
        Z = squareform(d);
        Z(Z == 0) = NaN;
        ter_dist_bright = [ter_dist_bright min(min(Z))];
    end
end
% remove nans
ter_coord = ter_coord(~isnan(ter_coord(:,1)),:);
mukb_coord = mukb_coord(~isnan(mukb_coord(:,1)),:);

% mean distances
fprintf('\n')
disp(['no. cells = ' num2str(length(ter_dist_bright))])
fprintf('\n')
disp(['MukB-ter dists - mean = ' num2str((mean(ter_dist_bright.*pixel)))])
% disp(['random MukB-ter dists - mean = ' num2str((mean(rand_ter_dist_bright.*pixel)))])

% cdfs
figure; hold on;
[f,x,flo,fup] = ecdf(ter_dist_bright.*pixel);
plot(x,f,'r','LineWidth',1.5)

[h1, I1] = hist(ter_dist_bright,0:0.5:max(ter_dist_bright));
h1 = h1./sum(h1);
figure; bar(I1.*pixel,h1)
title('MukB-ter')

%% Brightest pixel position along long cell axis

no_ori = 1;     % number of ori spots in the cell

% select *_pop_spots.mat file(s)
[filename,pathname] = uigetfile('*.mat', 'Select','MultiSelect', 'on');
if iscell(filename)
    no_files = length(filename);
    filename_cell = filename;
else
    no_files = 1;
    filename_cell{1} = filename;
end
   
L_pos = [];
no_cells = 0;
for kk = 1:no_files
    % load files
    load([pathname filename_cell{kk}]);
    
    for ii = 1:length(spots)
        if ~isempty(spots(ii).fluo1.l) && length(spots(ii).fluo1.l) == no_ori
            [~,ind] = max(spots(ii).fluo3A.Int);
            L_pos = [L_pos spots(ii).fluo3A.l(ind)./spots(ii).length];
            no_cells = no_cells + 1;
        end
    end
end

[h1, I1] = hist(L_pos, min(L_pos):0.02:max(L_pos));
h1 = h1./sum(h1);
figure; plot(I1,h1)
axis([-0.5 0.5 0 Inf])
